FONTS = {}

FONTS.small = {
	widthAdjust = -4,
	heightAdjust = -14,
	Xheight = 15,
}

FONTS.medium = {
	widthAdjust = -4,
	heightAdjust = -17,
	Xheight = 18,
}

FONTS.big = {
	widthAdjust = -6,
	heightAdjust = -30,
	Xheight = 34,
}

fonts = {}
fonts.sizes = {"small", "medium", "big"}

function fonts.alignY(fontname, alignment, scale)
	local alignment = alignment or 1
	local scale = scale or 1
	return -FONTS[fontname].Xheight/2*alignment*scale
end

function fonts.init()
	local path = daisy.getUserFolderPath("/daisyMoon/lib/fonts/")
	local contents = daisy.getFolderContents(path, "*.dat")	
	for index, row in pairs(contents) do
		local fontName = string.sub(row, 1, string.len(row) - string.len(".dat"))
		FONTS[fontName] = FONTS[fontName] or {}
		local names = video.getSpriteStateNames("fonts/"..row)
		for index, name in pairs(names) do
			FONTS[fontName][tonumber(name)] = {sprite = video.createSpriteState(name, "fonts/"..row)}
			FONTS[fontName][tonumber(name)].w, FONTS[fontName][tonumber(name)].h = video.getSpriteStateOriginalSize(FONTS[fontName][tonumber(name)].sprite)
			FONTS[fontName][tonumber(name)].w = FONTS[fontName][tonumber(name)].w + (FONTS[fontName].widthAdjust or 0)
			FONTS[fontName][tonumber(name)].h = FONTS[fontName][tonumber(name)].h + (FONTS[fontName].heightAdjust or 0)
		end
		
		if not FONTS[fontName][32] then
			FONTS[fontName][32] = {w = FONTS[fontName][105].w, h = FONTS[fontName][105].h}
		end
	end
end